#include <ButtonConstants.au3>
#include <ComboConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include "AviCap.au3"

Global $sAviFile=""

_AviCap_LoadDll()
	If @Error Then Exit MsgBox(16, @Error, " _AviCap_LoadDll")


$hWnd = GUICreate("AviCap Test", 641, 564)
	GUISetBkColor(0xFFFFFF)

$hWebcamWnd = _AviCap_CapCreateCaptureWindow($hWnd, 0, 0, 640, 480, 1)

GUICtrlCreateLabel(":", 12, 498, 52, 17)
$hDriver = GUICtrlCreateCombo("", 74, 495, 226, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
$hDriverConn = GUICtrlCreateButton("", 306, 493, 75, 25)
$hDriverDisconnect = GUICtrlCreateButton("", 390, 493, 75, 25)

$hCreateBmp = GUICtrlCreateButton(" ", 522, 493, 107, 25)

$vVideoFileLabel = GUICtrlCreateLabel(" :", 12, 530, 421, 17)
$hVideoSel = GUICtrlCreateButton("...", 442, 530, 36, 25)
$hRecStart = GUICtrlCreateButton("", 489, 530, 66, 25)
$hRecStop = GUICtrlCreateButton("", 565, 530, 66, 25)


Local $aDriversInfo, $i, $sData=""
$aDriversInfo = _AviCap_CapGetDriverDescription()
	If NOT @Error Then
	For $i = 1 To $aDriversInfo[0][0]
		If $sData = "" Then
		$sData = $aDriversInfo[$i][0]&": "&$aDriversInfo[$i][1]&" - "&$aDriversInfo[$i][2]
		Else
		$sData &= "|"&$aDriversInfo[$i][0]&": "&$aDriversInfo[$i][1]&" - "&$aDriversInfo[$i][2]
		EndIF
	Next
	EndIF
GUICtrlSetData($hDriver, $sData)

GUICtrlSetState($hDriverDisconnect, $GUI_DISABLE)
GUICtrlSetState($hCreateBmp, $GUI_DISABLE)
GUICtrlSetState($hRecStart, $GUI_DISABLE)
GUICtrlSetState($hRecStop, $GUI_DISABLE)


GUISetState(@SW_SHOW)
While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			_AviCap_RecVideo_Stop($hWebcamWnd)
			_AviCap_CapDriverDisconnect($hWebcamWnd)
			_AviCap_DeleteCaptureWindow($hWebcamWnd)
			_AviCap_UnloadDll()
			Exit


		Case $hDriverConn
			$sData = GUICtrlRead($hDriver)
				If $sData = "" Then ContinueLoop
			GUICtrlSetState($hDriverConn, $GUI_DISABLE)
			$iDriverIndex = StringLeft($sData, 1)
			_AviCap_CapDriverConnect($hWebcamWnd, $iDriverIndex, 1, 10)
			GUICtrlSetState($hDriverDisconnect, $GUI_ENABLE)
			GUICtrlSetState($hCreateBmp, $GUI_ENABLE)
			$sAviFile = ""
			GUICtrlSetData($vVideoFileLabel, " : "&$sAviFile)


		Case $hDriverDisconnect
			GUICtrlSetState($hDriverDisconnect, $GUI_DISABLE)
			GUICtrlSetState($hCreateBmp, $GUI_DISABLE)
			GUICtrlSetState($hRecStart, $GUI_DISABLE)
			GUICtrlSetState($hRecStop, $GUI_DISABLE)
			_AviCap_CapDriverDisconnect($hWebcamWnd)
			GUICtrlSetState($hDriverConn, $GUI_ENABLE)
			$sAviFile = ""
			GUICtrlSetData($vVideoFileLabel, " : "&$sAviFile)


		Case $hCreateBmp
			$sOutFile = FileSaveDialog(" ", @ScriptDir, " (*.bmp;*.jpg)", 18, @HOUR&"-"&@MIN&"-"&@SEC&".bmp")
				If @Error Then ContinueLoop
			_AviCap_CapFileSaveDib($hWebcamWnd, $sOutFile)
				If @Error Then MsgBox(0+48, @Error, "  ", 2, $hWnd)


		Case $hVideoSel
			$sOutFile = FileSaveDialog(" ", @ScriptDir, " (*.avi)", 18, @HOUR&"-"&@MIN&"-"&@SEC&".avi")
				If @Error Then ContinueLoop
			_AviCap_RecVideo_SetOutVideoFile($hWebcamWnd, $sOutFile)
				If @Error Then MsgBox(0+48, @Error, "  ", 2, $hWnd)
			_AviCap_RecVideo_Config($hWebcamWnd, 1, 1, 0, 0)
				If @Error Then MsgBox(0+48, @Error, "  ", 2, $hWnd)
			$sAviFile = $sOutFile
			GUICtrlSetData($vVideoFileLabel, " : "&$sAviFile)
			GUICtrlSetState($hRecStart, $GUI_ENABLE)


		Case $hRecStart
			If $sAviFile = "" Then ContinueLoop
			GUICtrlSetState($hRecStart, $GUI_DISABLE)
			_AviCap_RecVideo_Start($hWebcamWnd)
				If @Error Then
				MsgBox(0+48, @Error, "  ", 2, $hWnd)
				GUICtrlSetState($hRecStart, $GUI_ENABLE)
				ContinueLoop
				EndIF
			GUICtrlSetState($hRecStop, $GUI_ENABLE)


		Case $hRecStop
			GUICtrlSetState($hRecStop, $GUI_DISABLE)
			_AviCap_RecVideo_Stop($hWebcamWnd)
				If @Error Then MsgBox(0+48, @Error, "  ", 2, $hWnd)
			GUICtrlSetState($hRecStart, $GUI_ENABLE)

	EndSwitch
WEnd





